<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Route;
use App\Traits\Helper;

// Route::prefix('admin')->group(function(){
//
//
// Route::get('/login', "Auth\AdminLoginController@showloginForm")->name('admin.login');
// Route::post('/login', "Auth\AdminLoginController@login")->name('admin.login.submit');
// Route::get('/', "AdminController@index")->name('admin.dashboard');
//
// });

//Route::post('/loginAuthenticate',"authController@authenticate");


 Route::post('/DashboardLogin',"UserDashBoard@DashboardLogin");





/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/




Route::group([ "prefix" => 'admin'],function(){
    Auth::routes();

});
Route::get('/', "Auth\LoginController@showloginForm")->name('default');

Route::get('/login/vendor', 'Auth\LoginController@showUserLoginForm');

Route::post('/login/vendor', 'Auth\LoginController@vendorLogin');
//orders
Route::get('/home','HomeController@index');

    Route::group(['namespace' => 'Web'],function(){

Route::group(['middleware' => ['PreventBackHistory','auth:vendor']],function(){
   Route::get("/", "VendorController@index")->name("vendor.index");

       Route::get("vendorsettings","VendorSettingsController@index")->name("vendorsettings.index");
    Route::post("vendorsettingsstore","VendorSettingsController@store")->name("vendorsettings.store");
   // Profile Route


      Route::get("/vendor/profile", "VendorController@profile")->name("vendor.profile");
   Route::put("/vendor/profile/{id}", "VendorController@saveProfile")->name("vendor.saveProfile");
  Route::get('/vendorOrders','VendorController@Order')->name("vendor.Orders");


    Route::prefix("vendor/item")->name("vendor.item.")->group(function (){
        Route::get("/create", "ItemController@create")->name("create");
        Route::post("/store", "ItemController@store")->name("store");
        Route::get("/indexitem", "ItemController@index")->name("index");
        Route::get("/{category_id}/show", "ItemController@show")->name("show");
        Route::get("/edit/{id}", "ItemController@edit")->name("edit");
        Route::put("/{id}", "ItemController@update")->name("update");
        Route::delete("/{id}", "ItemController@destroy")->name("destroy");
    });
});




Route::group(['middleware' => ['ConnectionToken','PreventBackHistory','auth:web',"lang","url.lang.default"],"prefix" => "/{lang}/"],function(){
    Route::get('/index', "UserDashBoard@index")->name("admin.index");

    Route::resource("users", "UserController", [
        "except" => ["show","index"],
        "names" => [
            "create" => "admin.users.create",
            "store" => "admin.users.store",
            "edit" => "admin.users.edit",
            "update" => "admin.users.update",
            "destroy" => "admin.users.destroy"
        ]]);

    Route::prefix("admins")->name('admins.')->group(function (){
        Route::get("/", "UserDashboardController@index")->name("index");
    });

    Route::get("users/stores","UserController@getUsersStore")->name("admin.users.stores");
    Route::get("users/admins","UserController@getUserAdmins")->name("admin.users.admins");


    Route::post('get-store-by-classification', "BranchesController@getStoresVendorId");

    Route::get('/offer',"offerController@index");
    Route::get('/CreateOffer',"offerController@showCreateOffer");

    Route::resource("roles","RoleController");
    /////// USERS Route

    Route::get("users/app", "UsersController@index")->name("users.app.index");

        Route::get("users/driver", "UsersController@driverindex")->name("users.driver.index");
    Route::get("users/createDriver", "UsersController@createDriver")->name("users.driver.create");
    Route::post("users/storeDriver", "UsersController@storeDriver")->name("users.driver.store");

    Route::get("users/vendor", "UsersController@vendorindex")->name("users.vendor.index");

    Route::delete("users/app/{id}", "UsersController@destroy")->name("users.app.destroy");

//    Restaurants
    Route::get('/AddRestaurant', "RestaurantsController@AddRestaurant")->name("AddRestaurant");
    Route::post('/PostRestaurant', 'RestaurantsController@AddNewRestaurant');
//    store
    Route::get('/Restaurants', 'RestaurantsController@index')->name("Restaurants");


    Route::prefix("profile")->name("profile.")->group(function (){
        Route::get("/", "ProfileController@index")->name("index");
        Route::put("/save", "ProfileController@save")->name("save");
    });

    Route::prefix("orders")->name("orders.")->group(function (){
        Route::get('/index','OrdersController@index')->name("index");
    });

    Route::prefix("stores")->name("stores.")->group(function (){
        Route::get("/", "StoreController@index")->name("index");
        Route::get("/create", "StoreController@create")->name("create");
        Route::post("/store", "StoreController@store")->name("store");
        Route::post("/destroy", "StoreController@destroy")->name("destroy");
    });

    Route::prefix("classification")->name("classification.")->group(function (){
        Route::get("/", "ClassificationController@index")->name("index");
        Route::get("/create", "ClassificationController@create")->name("create");
        Route::post("/store", "ClassificationController@store")->name("store");
        Route::get("/edit/{id}", "ClassificationController@edit")->name("edit");
        Route::put("/update/{id}","ClassificationController@update")->name("update");
        Route::delete("/{id}", 'ClassificationController@destroy')->name('destroy');
    });

    Route::prefix("categories")->name("categories.")->group(function (){
        Route::get("/create", "CategoriesController@create")->name("create");
        Route::post("/store", "CategoriesController@store")->name("store");
        Route::get("/", "CategoriesController@index")->name("index");
//        Route::get("/{category_id}/show", "CategoriesController@show")->name("show");
        Route::get("/edit/{id}", "CategoriesController@edit")->name("edit");
        Route::post("/{id}", "CategoriesController@update")->name("update");
        Route::delete("/{id}", "CategoriesController@destroy")->name("destroy");
    });

    Route::prefix("sliders")->name("sliders.")->group(function (){
        Route::get("/", "SliderHomeController@index")->name("index");
        Route::get('/create', 'SliderHomeController@create')->name('create');
        Route::post('/store','SliderHomeController@store')->name('store');
        Route::get('/edit/{id}','SliderHomeController@edit')->name('edit');
        Route::put('/update/{id}','SliderHomeController@update')->name('update');
        Route::delete('/delete/{id}','SliderHomeController@destroy')->name('destroy');
    });

    // about as
    Route::prefix("about-us")->name("about_us.")->group(function (){
        Route::get("/", "AboutUsController@index")->name("index");
        Route::get('/create', 'AboutUsController@create')->name('create');
        Route::post('/store','AboutUsController@store')->name('store');
        Route::delete('/delete/{id}','AboutUsController@destroy')->name('destroy');
        Route::get('/edit/{id}','AboutUsController@edit')->name('edit');
        Route::put("/update/{id}","AboutUsController@update")->name("update");
    });
    Route::prefix("register")->name("register.")->group(function (){
        Route::get('/driver', 'RegisterFormDriverController@index')->name('driver');
        Route::put('/driver/{id}', 'RegisterFormDriverController@update')->name('driver.update');
        Route::delete('/driver/destroy/{id}', 'RegisterFormDriverController@destroy')->name('driver.destroy');
    });
    Route::prefix("notification")->name("notification.")->group(function (){
        Route::get("/send-for-all", "NotificationsController@ShowSendForAll")->name("send_for_all");
        Route::get("/send-for-custom", "NotificationsController@ShowSendForCustom")->name("send_for_custom");
        Route::post("/send", "NotificationsController@send")->name("send");
    });


    Route::prefix("user-vendor")->name("user_vendor.")->group(function (){
        Route::get("/", "UserVendorController@index")->name("index");
        Route::get("/create", "UserVendorController@create")->name("create");
        Route::get("/get-by-vendor", "UserVendorController@getByVendor")->name("get_by_vendor");
        Route::get("/edit/{id}", "UserVendorController@edit")->name("edit");
        Route::post("/store", "UserVendorController@store")->name("store");
        Route::put("/update/{id}", "UserVendorController@update")->name("update");
        Route::delete("/delete/{id}", "UserVendorController@destroy")->name("destroy");
    });


    Route::prefix("settings")->name("settings.")->group(function (){
        Route::get("/","SettingsController@index")->name("index");
        Route::post("/savesettings","SettingsController@save")->name("save");
    });

    //orders
    Route::get('/showStoreOrders','OrdersController@showStoreOrders');



    //app users
         Route::prefix("UsersApp")->name("UsersApp.")->group(function (){
    Route::get('/index','UsersAppController@index')->name("index");
    });


    Route::get('/userDriver','UsersAppController@getDriver');

    //user store

    Route::get('/userStore','UsersAppController@getUsersStore');


    //VOR users
    Route::get('/UserVor','UsersAppController@getUserVor');

    //vor
    Route::get('/Vor','UsersAppController@getStoreVorData');
    Route::post('/updatePasswordVor','UsersAppController@updatePasswordVor');



    //Edite store  in Restaurants controller
        Route::prefix("ShowEdite")->name("ShowEdite.")->group(function (){
    Route::get('showBranches','RestaurantsController@EditeStorePage')->name("edit");
    });
    // Route::get('/ShowEdite','Restaurants@EditeStorePage');
         Route::prefix("EditeStore")->name("EditeStore.")->group(function (){
    Route::post('update/{id}','RestaurantsController@update')->name("update");
    });
    // Route::post('/EditeStore','RestauRestaurantsControllerrants@EditeStore');
    Route::post('/DeleteStore','RestaurantsController@DeleteStore');



    //slider
    Route::get('/Slider', 'SliderController@getSlider');
    Route::post('/createSlider', 'SliderController@createNewSlider');
    Route::get('/EditSliderPage', 'SliderController@EditeSliderPage');
    Route::post('/EditeSlider','SliderController@EditeSlider');


      Route::prefix("storeCategory")->name("storeCategory.")->group(function (){
    Route::get('storeCategory','storeCategoryController@getStoreCategory')->name("index");
    });
    //categry
       Route::prefix("addCategory")->name("addCategory.")->group(function (){
    Route::post('addCategory','storeCategoryController@store')->name("store");
    });
    // Route::post('/addCategory', 'storeCategoryController@store');

      Route::prefix("UpdateStoreCategory")->name("UpdateStoreCategory.")->group(function (){
    Route::post('UpdateStoreCategory','storeCategoryController@update')->name("update");
    });
    // Route::post('/UpdateStoreCategory', 'storeCategoryController@update');
    Route::prefix("DeleteCategory")->name("DeleteCategory.")->group(function (){
        Route::delete('/DeleteCategory/{id}', 'storeCategoryController@destroy')->name("destroy");
    });

    Route::prefix("shipments")->name("shipments.")->group(function(){
        Route::get("ShipmentsSize","ShipmentController@sizeIndex")->name("size.index");
        Route::get("ShipmentsWeight","ShipmentController@weightIndex")->name("weight.index");
        Route::get("ShipmentsWithin","ShipmentController@WithinIndex")->name("Within.index");


        Route::get("CreateSize","ShipmentController@createSize")->name("size.create");
        Route::get("Createweight","ShipmentController@createWeight")->name("weight.create");
        Route::get("CreateWithin","ShipmentController@createWithin")->name("Within.create");

        Route::post("sizeStoreShipments","ShipmentController@storeSizes")->name("size.store");
        Route::post("weightStoreShipments","ShipmentController@storeWeights")->name("weight.store");
        Route::post("WithinStoreShipments","ShipmentController@storeWithins")->name("Within.store");

        Route::get("EditSize/{id}","ShipmentController@editsize")->name("size.edit");
        Route::get("EditWithins/{id}","ShipmentController@editwithins")->name("Within.edit");
        Route::get("EditWeights/{id}","ShipmentController@editweights")->name("Weight.edit");

        Route::post("UpdateSize/{id}","ShipmentController@updatesize")->name("size.update");
        Route::post("UpdateWithins/{id}","ShipmentController@updatewithins")->name("Within.update");
        Route::post("UpdateWeights/{id}","ShipmentController@updateweights")->name("Weight.update");

        Route::delete("DistroySize/{id}","ShipmentController@destroysize")->name("size.destroy");
        Route::delete("DistroyWithins/{id}","ShipmentController@destroyWithin")->name("Within.destroy");
        Route::delete("DistroyWeights/{id}","ShipmentController@destroyWeight")->name("weight.destroy");

    });

    Route::prefix("items")->name("items.")->group(function (){
    Route::get('items','itemsController@getItems')->name("index");
    Route::get('Edit/{id}','itemsController@EditItem')->name("edit");
      Route::put('update/{id}','itemsController@update')->name("update");
    });
    //item
    // Route::get('/items','itemsController@getItems');

    Route::prefix("AddItem")->name("AddItem.")->group(function (){
    Route::get('AddItem','itemsController@create')->name("Add");

    });
   Route::prefix("ShowEditeItem")->name("ShowEditeItem.")->group(function (){
    Route::get('ShowEditeItem','itemsController@ShowEditeItem')->name("show");

    });
    // Route::get('/ShowEditeItem','itemsController@ShowEditeItem');
      Route::prefix("PostItem")->name("PostItem.")->group(function (){
    Route::post('AddItem','itemsController@AddNewItem')->name("store");

    });
    // Route::post('PostItem', 'itemsController@AddNewItem');
    Route::post('/EditeItem','itemsController@EditeItem');


    //addons

    Route::get("items/{id}/add_ons","AddOnsController@index")->name("items.add_ons");
    Route::get("items/{id}/add_ons/create","AddOnsController@create")->name("items.add_ons.create");
    Route::post("items/{id}/add_ons","AddOnsController@store")->name("items.add_ons.store");
    Route::get("items/{item_id}/add_ons/{id}/edit","AddOnsController@edit")->name("items.add_ons.edit");
    Route::put("items/{item_id}/add_ons/{id}","AddOnsController@update")->name("items.add_ons.update");
    Route::delete("items/{item_id}/add_ons/{id}/","AddOnsController@destroy")->name("items.add_ons.destroy");

    Route::get("/DeleteOption/{id}","AddOnsOptionsController@destroyWEB")->name("add_ons_option.destroy");
    Route::get("/EditOption/{id}","AddOnsOptionsController@edit")->name("add_ons_option.Edit");
    Route::put("/updateOption/{id}","AddOnsOptionsController@update")->name("add_ons_option.update");






    //branches
        Route::prefix("showBranches")->name("showBranches.")->group(function (){
    Route::get('showBranches','BranchesController@index')->name("index");
    });


    // Route::get('/showBranches','BranchesController@index');

Route::prefix("AddBranch")->name("AddBranch.")->group(function (){
    Route::post('AddBranch','BranchesController@AddBranch')->name("Add");
    });
    // Route::post('AddBranch','BranchesController@AddBranch');

     Route::prefix("EditBranch")->name("EditBranch.")->group(function (){
    Route::get('EditBranch','BranchesController@EditBranch')->name("edit");
    });

    // Route::get('/EditBranch',"BranchesController@EditBranch");

  Route::prefix("SendEditBranch")->name("SendEditBranch.")->group(function (){
    Route::post('SendEditBranch','BranchesController@SendEditBranch')->name("send");
    });
    // Route::post('/SendEditBranch',"BranchesController@SendEditBranch");


  Route::prefix("showAddBranchepage")->name("showAddBranchepage.")->group(function (){
    Route::get('showAddBranchepage','BranchesController@show')->name("show");
    });

      Route::prefix("SelectAddress")->name("SelectAddress.")->group(function (){
  Route::get("SelectAddress", "BranchesController@Select")->name("select");
      });




       Route::prefix("showBranches")->name("showBranches.")->group(function (){
    Route::get('showBranches/{StoreID}','BranchesController@index')->name("index");
    });





});

//error
//Route::get('/Error', function () {return view('404');});
//Route::get('/TokenError', function () {return view('TokenError');});






Route::get('/home', 'HomeController@index')->name('home');
//Route::post('/check-back',"UserActionsController@checkBack");


});
